<!DOCTYPE html>
<html lang="en">
<head>
    <!-- Meta Tag -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo (isset($mataTitle)) ? $mataTitle.' | ': ''; ?> <?php echo $details['site_name'] ?></title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="IPTV StreamBox Web is a fabulous video streaming player that allows your IPTV customers or end-users to stream content like Live TV, VOD, Series, and TV Catchup.">
    <meta name="keywords" content="iptv, streambox">

    <!-- Favicon -->
    <link href="<?php echo $details['web_favicon'] ?>" rel="icon">
    
    <!-- IOS Touch Icons -->
    <link rel="apple-touch-icon" href="<?php echo $details['web_favicon'] ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo $details['web_favicon'] ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo $details['web_favicon'] ?>">
    <link rel="apple-touch-icon" sizes="167x167" href="<?php echo $details['web_favicon'] ?>">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Ubuntu:wght@300;400;500;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link rel="stylesheet" href="<?= base_url('css/plugins.bundle.css?v=3.0.0') ?>" type="text/css">
    <link rel="stylesheet" href="<?= base_url('css/styles.bundle.css?v=3.0.0') ?>" type="text/css">
    
    <!-- Global Base URL -->
    <script>var base_url = '<?php echo base_url() ?>';</script>

</head>

<style>
    body:before {
        background-color: none;
        backdrop-filter: none;
    }
</style>

<body>
    <div class="list-group list-group--embedded list-group-flush">
        <div class="list-group-item p-3 d-flex align-items-center">
            <div class="list-group__cover border">
                <a>
                    <img src="<?php echo $radio_data[0]['image'];?>" alt="">
                </a>
            </div>
            <div class="list-group__content ps-3">
                <a class="list-group__title text-truncate"><?php echo $radio_data[0]['radio_title'];?></a>
                <span class="list-group__subtitle"><?php echo $radio_data[0]['category_name'];?></span>
                <button id="embedded_play" class="btn btn-red rounded-pill mt-3">
                    <div class="btn-wrap">
                        <span id="embedded_play_text">Play Now</span>
                        <i class="ri-play-fill icon-play"></i>
                        <i class="ri-pause-fill icon-pause"></i>
                    </div>
                </button>
                <div class="text-end">
                    <a href="<?php echo base_url() ?>" class="text-decoration-none text-primary" style="color: inherit;" target="_blank"><?php echo $details['site_name'] ?></a>
                </div>
            </div>
        </div>
    </div>

    <!-- You have to change this url dynamically -->
    <audio id="embedded_player" src="<?php echo $radio_data[0]['radio_url'];?>" controls></audio>
    
    <!-- Scripts -->
    <script src="<?= base_url('/js/plugins.bundle.js?v=3.0.0') ?>"></script>
    <script src="<?= base_url('/js/scripts.bundle.js?v=3.0.0') ?>"></script>
</body>
</html>